package com.mesonbuild;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class Resources {
    public static void main(String[] args) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(
                Resources.class.getResourceAsStream("/resource1.txt"),
                StandardCharsets.UTF_8)) {
            final BufferedReader buffered = new BufferedReader(reader);

            assert buffered.readLine() == "1";
        }

        try (InputStreamReader reader = new InputStreamReader(
                Resources.class.getResourceAsStream("/subdir/resource2.txt"),
                StandardCharsets.UTF_8)) {
            final BufferedReader buffered = new BufferedReader(reader);

            assert buffered.readLine() == "2";
        }
    }
}
